<?php
session_start();
require_once "db_connection.php";

// چک کردن ورود کاربر
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// اتصال به دیتابیس و بازیابی اطلاعات کاربر
$servername = "localhost";
$username = "anreoalb_archive";
$password = "Shahrooz@2681";
$dbname = "anreoalb_archive";

// اتصال به دیتابیس
$conn = new mysqli($servername, $username, $password, $dbname);

// بررسی اتصال
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// بازیابی شناسه پرونده از درخواست GET
$file_id = $_GET['file_id'];

// بازیابی نوع درخواست و مرحله فعلی
$request_query = "SELECT request_type, stage_id, assigned_to FROM files WHERE file_id = ?";
$stmt = $conn->prepare($request_query);
$stmt->bind_param("i", $file_id);
$stmt->execute();
$result = $stmt->get_result();
$request_row = $result->fetch_assoc();
$request_type = $request_row['request_type'];
$current_stage_id = $request_row['stage_id'];
$assigned_to = $request_row['assigned_to'];

// بر اساس نوع درخواست، ورک‌فلو مناسب را بازیابی کنید
switch ($request_type) {
    case 'بهسازی و نوسازی گلخانه':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM bnstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'تمدید تاسیس گلخانه':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM ttstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'تمدید بهره برداری گلخانه':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM b2stage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'تمدید بهره برداری دام/طیور/شیلات':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM tbdstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'تغییر نام گلخانه':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM tnstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'تغییر کشت':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM tkstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'صدور بهره برداری گلخانه':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM bstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'اصلاح بهره برداری گلخانه':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM ebstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'تمدید توسعه گلخانه':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM tt2stage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'اصلاح تاسیس گلخانه':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM etstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'تمدید تاسیس قارچ':
    case 'تمدید توسعه قارچ':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM ttghstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'صدور تاسیس گلخانه':
    case 'صدور توسعه گلخانه':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM stages w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'تمدید دامداری غیر صنعتی':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM tdgstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'توسعه و افزایش ظرفیت دام/طیور/شیلات':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM tazstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'اصلاح تاسیس دام/طیور/شیلات':
    case 'اصلاح بهره برداری دام/طیور/شیلات':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM etdstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'تمدید تاسیس دام/طیور/شیلات':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM ttdstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'صدور بهره برداری دام/طیور/شیلات':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM sbdstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'موافقت اصولی دام/طیور/شیلات':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM mostage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'صدور تاسیس دام/طیور/شیلات':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM stdstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'تغییر نام بهره برداری دام':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM tntstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'صدور دامداری غیر صنعتی':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM sdgstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'صدور تاسیس داروخانه گیاهپزشکی':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM stgstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'تغییر نام تاسیس دام/طیور/شیلات':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM tntstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'اصلاح دامداری غیر صنعتی':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM edgstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'صدور بهره برداری انسکتاریوم':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM sistage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'تمدید بهره برداری انسکتاریوم':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM tbigstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'اصلاح انسکتاریوم':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM eistage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'تغییر نام انسکتاریوم':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM tnigstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    case 'صدور بهره برداری کلینیک گیاهپزشکی':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM sbcstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
        
    case 'تمدید تاسیس داروخانه':
    case 'تمدید کلینیک گیاهپزشکی':
        $workflow_query = "SELECT w.stage_id, w.stage_name, u.first_name, u.last_name
                           FROM ttcstage w 
                           LEFT JOIN users u ON w.user_id = u.user_id";
        break;
    default:
        echo "درخواست معتبر نیست.";
        exit;
}

// اجرای کوئری و بازیابی ورک‌فلو
$workflow_result = $conn->query($workflow_query);
?>

<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>مشاهده ورک‌فلو</title>
    <link rel="stylesheet" href="workflow.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        .completed-stage {
            background-color: #f2f2f2; /* هایلایت خاکستری */
        }
        .current-stage {
            font-weight: bold; /* هایلایت مرحله فعلی */
        }
        .tick-icon {
            color: green; /* رنگ تیک سبز */
            margin-left: 5px; /* فاصله از متن */
        }
    </style>
</head>
<body>
<div class="container">
    <header>
        <h2>ورک‌فلو پرونده شماره <?php echo $file_id; ?></h2>
    </header>
    <main>
        <?php if ($workflow_result->num_rows > 0) { ?>
            <table>
                <thead>
                <tr>
                    <th>ردیف</th>
                    <th>نام مرحله</th>
                    <th>نام کارشناس</th>
                    <th>وضعیت</th>
                </tr>
                </thead>
                <tbody>
                <?php 
                $row_number = 1; // اضافه کردن شماره ردیف
                while ($row = $workflow_result->fetch_assoc()) { ?>
                    <?php
                    // تعیین کلاس هایلایت
                    $class = '';
                    if ($row['stage_id'] < $current_stage_id) {
                        $class = 'completed-stage';
                        $tick_icon = '<i class="tick-icon fas fa-check-circle"></i>';
                    } elseif ($row['stage_id'] == $current_stage_id) {
                        $class = 'current-stage';
                        $tick_icon = '';
                    } else {
                        $class = '';
                        $tick_icon = '';
                    }
                    ?>
                    <tr class="<?php echo $class; ?>">
                        <td><?php echo $row_number++; ?></td>
                        <td><?php echo $row['stage_name']; ?></td>
                        <td><?php echo $row['first_name'] . ' ' . $row['last_name']; ?></td>
                        <td><?php echo $tick_icon; ?></td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        <?php } else { ?>
            <p>هیچ مرحله‌ای برای این درخواست موجود نیست.</p>
        <?php } ?>
    </main>
    <footer>
        <a href="inbox.php">بازگشت به صندوق ورودی</a>
    </footer>
</div>
</body>
</html>

<?php
$conn->close();
?>
