<?php
session_start();
require_once "db_connection.php";

// چک کردن ورود کاربر
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// اتصال به دیتابیس
$servername = "localhost";
$username = "anreoalb_archive";
$password = "Shahrooz@2681";
$dbname = "anreoalb_archive";

// اتصال به دیتابیس
$conn = new mysqli($servername, $username, $password, $dbname);

// بررسی اتصال
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// بازیابی شناسه پرونده از پارامتر GET
$file_id = $_GET['file_id'];

// دریافت یادداشت‌های موقت مرتبط با پرونده مشخص شده، نام و نام خانوادگی کاربران و نام مرحله
$query = "
SELECT f.temporary_note, u.first_name, u.last_name, f.stage_name
FROM files f
JOIN users u ON f.assigned_to = u.user_id
WHERE f.file_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $file_id);
$stmt->execute();
$result = $stmt->get_result();

// بستن اتصال به دیتابیس
$conn->close();
?>

<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>یادداشت‌های موقت پرونده</title>
    <link rel="stylesheet" href="table.css">
</head>
<body>
<div class="container">
    <header>
        <h2>یادداشت‌های موقت پرونده</h2>
    </header>
    <main>
        <?php if ($result->num_rows > 0) { ?>
            <table>
                <thead>
                <tr>
                    <th>نام</th>
                    <th>نام خانوادگی</th>
                    <th>یادداشت موقت</th>
                    <th>مرحله</th>
                </tr>
                </thead>
                <tbody>
                <?php while ($row = $result->fetch_assoc()) { ?>
                    <tr>
                        <td><?php echo $row['first_name']; ?></td>
                        <td><?php echo $row['last_name']; ?></td>
                        <td><?php echo $row['temporary_note']; ?></td>
                        <td><?php echo $row['stage_name']; ?></td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        <?php } else { ?>
            <p>هیچ یادداشت موقتی برای این پرونده ثبت نشده است.</p>
        <?php } ?>
    </main>
    <footer>
        <a href="inbox.php">بازگشت به صندوق ورودی</a>
    </footer>
</div>
</body>
</html>
