<?php
require_once "db_connection.php";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $id = $_POST['id'];
    $field = $_POST['field'];
    $value = $_POST['value'];

    // فیلدهای مجاز
    $allowedFields = array_merge(
        ['resolved1','resolved2','resolved3','resolved4','resolved5','resolved6','resolved7','resolved8','resolved9','resolved10'],
        ['taghir1','taghir2','taghir3','taghir4','taghir5','taghir6','taghir7','taghir8','taghir9','taghir10']
    );

    if (!in_array($field, $allowedFields)) {
        http_response_code(400);
        echo "Invalid field";
        exit;
    }

    // آپدیت فیلد اصلی
    if (strpos($field, 'resolved') === 0) {
        $stmt = $conn->prepare("UPDATE karshenasan SET $field = ? WHERE id = ?");
        $stmt->bind_param("ii", $value, $id);
        $stmt->execute();
        $stmt->close();
    } elseif (strpos($field, 'taghir') === 0) {
        // ذخیره مقدار تغییر کاربری در فیلد مرحله‌ای مثل taghir3
        $stmt = $conn->prepare("UPDATE karshenasan SET $field = ?, taghir_status = ? WHERE id = ?");
        $stmt->bind_param("ssi", $value, $value, $id);
        $stmt->execute();
        $stmt->close();
    }

    echo "success";
    $conn->close();
}
