<?php
session_start();
require_once "db_connection.php";

// چک کردن ورود کاربر
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// اتصال به دیتابیس
$servername = "localhost";
$username = "anreoalb_archive";
$password = "Shahrooz@2681";
$dbname = "anreoalb_archive";

// اتصال به دیتابیس
$conn = new mysqli($servername, $username, $password, $dbname);

// بررسی اتصال
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$national_code = "";
$results = [];

// پردازش فرم جستجو
if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET['national_code'])) {
    $national_code = $_GET['national_code'];
    
    // بازیابی اطلاعات پرونده‌های مرتبط با کد ملی
    $query = "
    SELECT f.file_id, f.operator_first_name, f.operator_last_name, f.national_code, f.request_type, f.stage_name, s.allowed_time, f.stage_start_time
    FROM files f
    JOIN stages s ON f.stage_id = s.stage_id
    WHERE f.national_code = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $national_code);
    $stmt->execute();
    $result = $stmt->get_result();
    $results = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
}

// بستن اتصال به دیتابیس
$conn->close();
?>

<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>جستجوی پرونده</title>
    <link rel="stylesheet" href="admin.css">
</head>
<body>
<div class="container">
    <header>
        <h2>جستجوی پرونده</h2>
    </header>
    <main>
        <form action="search.php" method="get">
            <input type="text" name="national_code" placeholder="کد ملی" value="<?php echo htmlspecialchars($national_code); ?>" required>
            <button type="submit">جستجو</button>
        </form>
        <?php if (count($results) > 0) { ?>
            <table>
                <thead>
                <tr>
                    <th>فایل آیدی</th>
                    <th>نام بهره بردار</th>
                    <th>نام خانوادگی بهره بردار</th>
                    <th>کد ملی</th>
                    <th>نوع درخواست</th>
                    <th>مرحله</th>
                    <th>زمان باقی‌مانده</th>
                    <th>ثبت نظر</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($results as $row) { ?>
                    <tr>
                        <td><?php echo $row['file_id']; ?></td>
                        <td><?php echo $row['operator_first_name']; ?></td>
                        <td><?php echo $row['operator_last_name']; ?></td>
                        <td><?php echo $row['national_code']; ?></td>
                        <td><?php echo $row['request_type']; ?></td>
                        <td><?php echo $row['stage_name']; ?></td>
                        <td>
                            <span class="timer" data-allowed-time="<?php echo $row['allowed_time']; ?>" data-start-time="<?php echo $row['stage_start_time']; ?>"></span>
                        </td>
                        <td>
                            <form class="comment-form" action="save_comment.php" method="post">
                                <input type="hidden" name="file_id" value="<?php echo $row['file_id']; ?>">
                                <textarea name="comment" rows="3" cols="30" placeholder="عملیات انجام شده را شرح دهید"></textarea>
                                <button type="submit">ثبت نظر</button>
                            </form>
                            <form action="view_comments.php" method="get" style="display:inline;">
                                <input type="hidden" name="file_id" value="<?php echo $row['file_id']; ?>">
                                <button type="submit">نمایش نظرات</button>
                            </form>
                        </td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        <?php } elseif ($national_code) { ?>
            <p>پرونده‌ای با کد ملی وارد شده یافت نشد.</p>
        <?php } ?>
    </main>
    <footer>
        <a href="admin_dashboard.php">بازگشت به داشبورد</a>
    </footer>
</div>
</body>
</html>
