<?php
// وارد کردن اطلاعات اتصال از فایل db_connection.php
include 'db_connection.php';

// ایجاد اتصال به دیتابیس
$conn = new mysqli($servername, $username, $password, $dbname);

// بررسی اتصال
if ($conn->connect_error) {
    die("خطا در اتصال به دیتابیس: " . $conn->connect_error);
}

// دریافت اطلاعات از فرم
$full_name = $_POST['full_name'];
$national_code = $_POST['national_code'];
$city = $_POST['shahrestan']; // shahrestan باید به city تغییر کند
$sec_name = $_POST['sec_name'];
$request_type = $_POST['request_type'];
$phone = $_POST['phone']; // دریافت شماره تماس

// بررسی نوع درخواست و درج اطلاعات در جدول مناسب
$table = '';
if ($request_type === 'طیور و سایر ماکیان') {
    $table = 'mtoyur';
} elseif ($request_type === 'دام صنعتی سبک') {
    $table = 'mdamsb';
} elseif ($request_type === 'دام صنعتی سنگین') {
    $table = 'mdamsa';
} elseif ($request_type === 'شیلات و آبزیان') {
    $table = 'mshilat';
} elseif ($request_type === 'گیاهپزشکی') {
    $table = 'mgiah';
} elseif ($request_type === 'دام غیر صنعتی') {
    $table = 'mgheir';
} elseif ($request_type === 'گلخانه و قارچ') {
    $table = 'mgolkhaneh';
} elseif ($request_type === 'آزمایشگاه آب و خاک') {
    $table = 'mazmayeshgah'; // اضافه کردن جدول آزمایشگاه آب و خاک
}

// اگر جدول مناسب پیدا شد، اطلاعات را درج کن
if (!empty($table)) {
    // SQL برای درج اطلاعات در جدول انتخاب‌شده
    $sql = "INSERT INTO $table (name, national_code, city, sec_name, request_type, phone)
            VALUES (?, ?, ?, ?, ?, ?)";

    // آماده‌سازی کوئری
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sissss", $full_name, $national_code, $city, $sec_name, $request_type, $phone);

    // اجرای کوئری و بررسی موفقیت
    if ($stmt->execute()) {
        // دریافت ID رکورد درج‌شده
        $last_id = $stmt->insert_id;
        echo "اطلاعات با موفقیت ذخیره شد. پرونده با شماره $last_id ثبت شد.";
    } else {
        echo "خطا در ذخیره اطلاعات: " . $stmt->error;
    }

    $stmt->close();
} else {
    echo "نوع درخواست نامعتبر است.";
}

// بستن اتصال
$conn->close();
?>
