<?php
session_start();
require_once "db_connection.php";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $file_id = $_POST['file_id'];
    $temp_notes = $_POST['temp_notes'];

    // Retrieve current temporary note from database
    $query_select = "SELECT temporary_note FROM files WHERE file_id = ?";
    $stmt_select = $conn->prepare($query_select);
    $stmt_select->bind_param("i", $file_id);
    $stmt_select->execute();
    $stmt_select->bind_result($current_temp_notes);
    $stmt_select->fetch();
    $stmt_select->close();

    // Append new temporary note to the existing one
    $updated_temp_notes = $current_temp_notes . "\n" . $temp_notes;

    // Update the files table with the updated temporary notes
    $query_update = "UPDATE files SET temporary_note = ? WHERE file_id = ?";
    $stmt_update = $conn->prepare($query_update);
    $stmt_update->bind_param("si", $updated_temp_notes, $file_id);

    if ($stmt_update->execute()) {
        // Temporary notes updated successfully
        header("Location: inbox.php"); // Redirect to inbox or wherever appropriate
        exit;
    } else {
        // Handle error
        echo "Error: " . $stmt_update->error;
    }
}
?>
