<?php
require_once 'jdf.php'; // تبدیل تاریخ شمسی
require_once 'lib/PhpSpreadsheet/vendor/autoload.php'; // PhpSpreadsheet
require_once 'db_connection.php'; // اتصال به دیتابیس

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

if (isset($_POST['export'])) {
    $startDate = $_POST['start_date']; // مثلاً 1403-01-01
    $endDate = $_POST['end_date'];     // مثلاً 1403-01-30

    $query = "SELECT first_name, last_name, national_code, registration_date, request_type, taghir_status,
                     x, y, date1, date2, date3, date4, date5, date6, date7, date8, date9, date10,
                     file1, file2, file3, file4, file5, file6, file7, file8, file9, file10,
                     jahad1, jahad2, jahad3, jahad4, jahad5, jahad6, jahad7, jahad8, jahad9, jahad10
              FROM karshenasan 
              WHERE registration_date BETWEEN '$startDate' AND '$endDate'";

    $result = $conn->query($query);

    if ($result && $result->num_rows > 0) {
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        $headers = [
                'نام', 'نام خانوادگی', 'کدملی', 'تاریخ ثبت', 'نوع درخواست', 'آخرین وضعیت تغییر کاربری',
                'X', 'Y',
                'تاریخ بازدید مرحله 1', 'تاریخ بازدید مرحله 2', 'تاریخ بازدید مرحله 3', 'تاریخ بازدید مرحله 4', 'تاریخ بازدید مرحله 5',
                'تاریخ بازدید مرحله 6', 'تاریخ بازدید مرحله 7', 'تاریخ بازدید مرحله 8', 'تاریخ بازدید مرحله 9', 'تاریخ بازدید مرحله 10',
                'گزارش مرحله 1', 'گزارش مرحله 2', 'گزارش مرحله 3', 'گزارش مرحله 4', 'گزارش مرحله 5',
                'گزارش مرحله 6', 'گزارش مرحله 7', 'گزارش مرحله 8', 'گزارش مرحله 9', 'گزارش مرحله 10',
                'نامه ارسالی به جهاد مرحله 1', 'نامه ارسالی به جهاد مرحله 2', 'نامه ارسالی به جهاد مرحله 3', 'نامه ارسالی به جهاد مرحله 4', 'نامه ارسالی به جهاد مرحله 5',
                'نامه ارسالی به جهاد مرحله 6', 'نامه ارسالی به جهاد مرحله 7', 'نامه ارسالی به جهاد مرحله 8', 'نامه ارسالی به جهاد مرحله 9', 'نامه ارسالی به جهاد مرحله 10'
            ];


        $col = 'A';
        foreach ($headers as $header) {
            $sheet->setCellValue($col . '1', $header);
            $col++;
        }

        $row = 2;
        while ($data = $result->fetch_assoc()) {
            $col = 'A';
            $sheet->setCellValue($col++ . $row, $data['first_name']);
            $sheet->setCellValue($col++ . $row, $data['last_name']);
            $sheet->setCellValue($col++ . $row, $data['national_code']);
            $sheet->setCellValue($col++ . $row, $data['registration_date']);
            $sheet->setCellValue($col++ . $row, $data['request_type']);
            $sheet->setCellValue($col++ . $row, $data['taghir_status']);
            $sheet->setCellValue($col++ . $row, $data['x']);
            $sheet->setCellValue($col++ . $row, $data['y']);

            // تاریخ بازدیدها
            for ($i = 1; $i <= 10; $i++) {
                $sheet->setCellValue($col++ . $row, $data["date$i"]);
            }

            // فایل‌ها: دارد / ندارد
            for ($i = 1; $i <= 10; $i++) {
                $sheet->setCellValue($col++ . $row, !empty($data["file$i"]) ? 'دارد' : 'ندارد');
            }

            // نامه‌های جهاد: دارد / ندارد
            for ($i = 1; $i <= 10; $i++) {
                $sheet->setCellValue($col++ . $row, !empty($data["jahad$i"]) ? 'دارد' : 'ندارد');
            }

            $row++;
        }

        // خروجی فایل
        $writer = new Xlsx($spreadsheet);
        $fileName = 'gozaresh_' . date('Ymd_His') . '.xlsx';

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("Content-Disposition: attachment; filename=\"$fileName\"");
        $writer->save('php://output');
        exit;
    } else {
        echo "<script>alert('داده‌ای برای این بازه یافت نشد.');</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>گزارش اکسل پرونده‌ها</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <div class="card shadow">
        <div class="card-header bg-primary text-white text-center">
            <h4>دریافت گزارش اکسل پرونده های نظارت ۶ ماهه اراضی</h4>
        </div>
        <div class="card-body">
            <form method="POST">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="start_date" class="form-label">تاریخ شروع (yyyy-mm-dd):</label>
                        <input type="text" name="start_date" id="start_date" class="form-control" placeholder="مثلاً 1403-01-01" required>
                    </div>
                    <div class="col-md-6">
                        <label for="end_date" class="form-label">تاریخ پایان (yyyy-mm-dd):</label>
                        <input type="text" name="end_date" id="end_date" class="form-control" placeholder="مثلاً 1403-01-30" required>
                    </div>
                </div>
                <button type="submit" name="export" class="btn btn-success w-100">دانلود فایل اکسل</button>
            </form>
        </div>
    </div>
</div>
</body>
</html>
