<?php
session_start();

// اتصال به دیتابیس
require 'db_connection.php';

$ip_address = $_SERVER['REMOTE_ADDR'];
$block_time = 2 * 60; // 5 دقیقه

// تابع برای بررسی تعداد تلاش‌های لاگین ناموفق
function check_login_attempts($conn, $ip_address, $block_time) {
    $stmt = $conn->prepare("SELECT COUNT(*) as attempt_count, MIN(attempt_time) as first_attempt
                            FROM login_attempts WHERE ip_address = ? AND attempt_time > NOW() - INTERVAL ? SECOND");
    $stmt->bind_param("si", $ip_address, $block_time);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    return $result;
}

// تابع برای ثبت تلاش ناموفق
function log_login_attempt($conn, $ip_address, $username, $password) {
    $stmt = $conn->prepare("INSERT INTO login_attempts (ip_address, attempt_time, username, password) VALUES (?, NOW(), ?, ?)");
    $stmt->bind_param("sss", $ip_address, $username, $password);
    $stmt->execute();
}

// تابع برای بررسی مسدود بودن IP
function is_ip_blocked($conn, $ip_address) {
    $stmt = $conn->prepare("SELECT * FROM blocked_ips WHERE ip_address = ? AND unblock_time > NOW()");
    $stmt->bind_param("s", $ip_address);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->num_rows > 0;
}

// تابع برای مسدود کردن IP
function block_ip($conn, $ip_address, $block_time) {
    $unblock_time = date('Y-m-d H:i:s', time() + $block_time);
    $stmt = $conn->prepare("INSERT INTO blocked_ips (ip_address, unblock_time) VALUES (?, ?)");
    $stmt->bind_param("ss", $ip_address, $unblock_time);
    $stmt->execute();
}

// بررسی ارسال فرم
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // دریافت اطلاعات ورودی
    $username = $_POST['username'];
    $password = $_POST['password'];
    $captcha = $_POST['captcha'];
    $num1 = $_POST['num1'];
    $num2 = $_POST['num2'];

    // بررسی کپچا
    if (($num1 + $num2) != $captcha) {
        echo "پاسخ کپچا اشتباه است. لطفاً دوباره تلاش کنید.";
        exit();
    }

    // بررسی مسدود بودن IP
    if (is_ip_blocked($conn, $ip_address)) {
        echo "آی‌پی شما به دلیل تلاش‌های ناموفق بیش از حد مسدود شده است. لطفاً بعداً دوباره تلاش کنید.";
        exit();
    }

    // بررسی تعداد تلاش‌های لاگین ناموفق
    $login_attempts = check_login_attempts($conn, $ip_address, $block_time);
    
    if ($login_attempts['attempt_count'] >= 3) {
        block_ip($conn, $ip_address, $block_time);
        echo "تعداد تلاش‌های ناموفق شما زیاد بوده است. آی‌پی شما به مدت 2 دقیقه مسدود شد.";
        exit();
    }

    // استعلام اطلاعات کاربر از دیتابیس
    $stmt = $conn->prepare("SELECT * FROM users WHERE username=? AND password=?");
    $stmt->bind_param("ss", $username, $password);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 1) {
        // اعتبارسنجی موفقیت‌آمیز بود
        $row = $result->fetch_assoc();
        $_SESSION['username'] = $row['username'];
        $_SESSION['role'] = $row['role'];

        // ثبت مجدد شناسه نشست
        session_regenerate_id();

        // انتقال به داشبورد مناسب بر اساس نقش کاربر
        switch ($_SESSION['role']) {
            case 'normal':
                header("Location: user_dashboard.php");
                break;
            case 'archive_manager':
                header("Location: archive_manager_dashboard.php");
                break;
            case 'admin':
                header("Location: admin_dashboard.php");
                break;
            default:
                // اگر نقش مشخص نشود، کاربر به صفحه خطا منتقل می‌شود
                header("Location: error_page.php");
                break;
        }
        exit();
    } else {
        // اعتبارسنجی ناموفق بود
        log_login_attempt($conn, $ip_address, $username, $password);
        echo "اطلاعات ورودی نامعتبر است.";
    }
}
?>
