<?php
session_start();
require_once "db_connection.php";

// بررسی ورود کاربر
if (!isset($_SESSION['username'])) {
    header("Location: login.html");
    exit;
}

// اتصال به دیتابیس
$conn = new mysqli($servername, $username, $password, $dbname);

// بررسی اتصال
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// دریافت اطلاعات ارجاع گیرندگان از جدول users
$users_query = "SELECT user_id, first_name, last_name FROM users";
$users_result = $conn->query($users_query);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $subject = $_POST["subject"];
    $description = $_POST["description"];
    $assignee_id = $_POST["assignee_id"];
    $allowed_days = $_POST["action_time"];

    // محاسبه تاریخ پایانی بر اساس مدت زمان مجاز
    $allowed_seconds = $allowed_days * 24 * 60 * 60;
    $end_date = date('Y-m-d H:i:s', strtotime("+" . $allowed_seconds . " seconds"));

    // آپلود فایل پیوست
    $attachment_path = '';
    if (isset($_FILES['attachment']) && $_FILES['attachment']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = 'attachments/'; // دایرکتوری ذخیره فایل‌های پیوست
        $uploadFile = $uploadDir . basename($_FILES['attachment']['name']);
        if (move_uploaded_file($_FILES['attachment']['tmp_name'], $uploadFile)) {
            $attachment_path = $uploadFile;
        } else {
            echo "خطا در آپلود فایل.";
            exit;
        }
    }

    // دریافت نام و نام خانوادگی ارجاع گیرنده
    $assignee_query = "SELECT first_name, last_name FROM users WHERE user_id = ?";
    $stmt = $conn->prepare($assignee_query);
    $stmt->bind_param("i", $assignee_id);
    $stmt->execute();
    $stmt->bind_result($first_name, $last_name);
    $stmt->fetch();
    $first_assignee_name = $first_name . ' ' . $last_name;
    $stmt->close();

    // درج نامه جدید به جدول letters با تاریخ پایانی محاسبه شده و مسیر فایل پیوست
    $insert_query = "INSERT INTO letters (subject, description, end_date, assignee_id, first_assignee_name, attachment_path) VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($insert_query);
    $stmt->bind_param("sssiss", $subject, $description, $end_date, $assignee_id, $first_assignee_name, $attachment_path);
    if ($stmt->execute()) {
        echo "<script>alert('نامه با موفقیت ثبت شد.'); window.location.href='inbox.php';</script>";
        exit;
    } else {
        echo "خطا در ثبت نامه: " . $conn->error;
    }

    $stmt->close();
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ثبت نامه</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="container">
        <h1>ثبت نامه جدید</h1>
        <form method="POST" action="" enctype="multipart/form-data">
            <label for="subject">موضوع نامه:</label>
            <input type="text" id="subject" name="subject" required>

            <label for="description">متن توضیحات:</label>
            <textarea id="description" name="description" required></textarea>

            <label for="action_time">مدت زمان مجاز اقدام (روز):</label>
            <input type="number" id="action_time" name="action_time" class="form-control" min="1" required>

            <label for="assignee_id">ارجاع گیرنده:</label>
            <select id="assignee_id" name="assignee_id" required>
                <option value="">انتخاب ارجاع گیرنده</option>
                <?php
                if ($users_result->num_rows > 0) {
                    while($row = $users_result->fetch_assoc()) {
                        echo '<option value="' . $row["user_id"] . '">' . $row["first_name"] . ' ' . $row["last_name"] . '</option>';
                    }
                }
                ?>
            </select>

            <label for="attachment">فایل پیوست:</label>
            <input type="file" id="attachment" name="attachment" accept=".pdf,.doc,.docx,.jpg,.jpeg">

            <button type="submit">ثبت نامه</button>
        </form>
    </div>
</body>
</html>
