<?php
require 'db_connection.php';
require 'jdf.php'; // فایل تبدیل تاریخ شمسی ↔ میلادی

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $first_name = $_POST['first_name'];
    $last_name = $_POST['last_name'];
    $national_code = $_POST['national_code'];
    $phone_number = $_POST['phone_number'];
    $expert_name = $_POST['expert_name'];
    $expert_phone = $_POST['expert_phone'];
    $request_type = $_POST['request_type'];
    $registration_date = $_POST['registration_date']; // مثلاً: 1403-02-01
    $des = $_POST['des'];

    // بررسی طول شماره ناظر
    if (strlen($expert_phone) > 20) {
        die("شماره تلفن ناظر بیش از حد طولانی است.");
    }

    // تبدیل تاریخ شمسی به میلادی برای محاسبه
    list($jy, $jm, $jd) = explode('-', $registration_date);
    $g_date_array = jalali_to_gregorian((int)$jy, (int)$jm, (int)$jd);
    $greg_date = implode('-', $g_date_array); // مثلاً: 2024-04-20

    // تعیین تعداد تاریخ‌های مرحله‌ای
    if (in_array($request_type, ['تاسیس دام صنعتی', 'تاسیس طیور', 'تاسیس گلخانه', 'تاسیس قارچ خوراکی', 'تاسیس شیلات'])) {
        $count = 4;
    } elseif ($request_type === 'دام غیر صنعتی خارج از بافت') {
        $count = 6;
    } elseif ($request_type === 'تمدید تاسیس گلخانه') {
        $count = 2;
    } elseif (in_array($request_type, ['بهره برداری گلخانه', 'بهره برداری قارچ خوراکی'])) {
        $count = 10;
    } elseif (in_array($request_type, ['بهره برداری دام صنعتی', 'بهره برداری طیور', 'بهره برداری شیلات'])) {
        $count = 8;
    } elseif ($request_type === 'صدور موافقت اصولی') {
        $count = 1;
    } else {
        $count = 0;
    }

    // محاسبه تاریخ‌های مرحله‌ای (شمسی)
    $dates = array_fill(0, 10, null); // پیش‌فرض خالی

    $start_date = new DateTime($greg_date);
    for ($i = 1; $i <= $count; $i++) {
        $step_date = clone $start_date;
        $step_date->add(new DateInterval('P' . ($i * 6) . 'M'));
        $next_g_date = $step_date->format('Y-m-d');

        list($gy, $gm, $gd) = explode('-', $next_g_date);
        $j_date = gregorian_to_jalali((int)$gy, (int)$gm, (int)$gd);
        $dates[$i - 1] = implode('-', $j_date); // تاریخ شمسی مرحله
    }

    // وضعیت پرداخت پیش‌فرض
    $pay_status = "پرداخت نشده";

    // ثبت اطلاعات در دیتابیس
    $sql = "INSERT INTO karshenasan (
        first_name, last_name, national_code, phone_number,
        expert_name, expert_phone, request_type, registration_date,
        date1, date2, date3, date4, date5, date6, date7, date8, date9, date10,
        pay_status, des
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        die('prepare() failed: ' . htmlspecialchars($conn->error));
    }

    $stmt->bind_param(
        "ssssssssssssssssssss",
        $first_name, $last_name, $national_code, $phone_number,
        $expert_name, $expert_phone, $request_type, $registration_date,
        $dates[0], $dates[1], $dates[2], $dates[3], $dates[4],
        $dates[5], $dates[6], $dates[7], $dates[8], $dates[9],
        $pay_status, $des
    );

    if ($stmt->execute()) {
        echo "<script>alert('اطلاعات با موفقیت ثبت شد.'); window.location.href = 'k_reg.html';</script>";
    } else {
        echo "خطا در ثبت اطلاعات: " . htmlspecialchars($stmt->error);
    }

    $stmt->close();
    $conn->close();
}
?>
