<?php

function div($a, $b) {
    return (int) ($a / $b);
}

function gregorian_to_jalali($gy, $gm, $gd) {
    $g_d_m = array(0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334);
    $gy2 = ($gm > 2) ? ($gy + 1) : $gy;
    $days = 355666 + (365 * $gy) + div($gy2, 4) - div($gy2, 100) + div($gy2, 400) + $gd + $g_d_m[$gm - 1];
    $jy = -1595 + (33 * div($days, 12053));
    $days %= 12053;
    $jy += 4 * div($days, 1461);
    $days %= 1461;
    if ($days > 365) {
        $jy += div($days - 1, 365);
        $days = ($days - 1) % 365;
    }
    $jm = ($days < 186) ? 1 + div($days, 31) : 7 + div($days - 186, 30);
    $jd = 1 + (($days < 186) ? ($days % 31) : (($days - 186) % 30));
    return array($jy, $jm, $jd);
}

function jalali_to_gregorian($jy, $jm, $jd) {
    $jy += 1595;
    $days = -355668 + (365 * $jy) + (div($jy, 33) * 8) + div(($jy % 33) + 3, 4) + $jd + (($jm < 7) ? ($jm - 1) * 31 : (($jm - 7) * 30) + 186);
    $gy = 400 * div($days, 146097);
    $days %= 146097;
    if ($days > 36524) {
        $gy += 100 * div(--$days, 36524);
        $days %= 36524;
        if ($days >= 365) $days++;
    }
    $gy += 4 * div($days, 1461);
    $days %= 1461;
    if ($days > 365) {
        $gy += div($days - 1, 365);
        $days = ($days - 1) % 365;
    }
    $gd = $days + 1;
    $sal_a = array(0, 31, (($gy % 4 == 0 && $gy % 100 != 0) || ($gy % 400 == 0)) ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
    for ($gm = 0; $gm < 13; $gm++) {
        if ($gd <= $sal_a[$gm]) break;
        $gd -= $sal_a[$gm];
    }
    return array($gy, $gm, $gd);
}

?>
