<?php
require_once 'db_connection.php';
include 'jdf.php'; // برای تبدیل تاریخ شمسی به میلادی

// تابع تبدیل UTM به طول و عرض جغرافیایی (WGS84)
function utmToLatLon($x, $y, $zone) {
    $a = 6378137.0;
    $e = 0.081819191;
    $e1sq = 0.006739497;
    $k0 = 0.9996;

    $x -= 500000.0;
    $x /= $k0;
    $y /= $k0;

    $zone_cm = 6 * $zone - 183.0;
    $M = $y;
    $mu = $M / ($a * (1 - pow($e,2)/4 - 3*pow($e,4)/64 - 5*pow($e,6)/256));

    $e1 = (1 - sqrt(1 - $e*$e)) / (1 + sqrt(1 - $e*$e));

    $J1 = (3*$e1/2 - 27*pow($e1,3)/32);
    $J2 = (21*pow($e1,2)/16 - 55*pow($e1,4)/32);
    $J3 = (151*pow($e1,3)/96);
    $J4 = (1097*pow($e1,4)/512);

    $fp = $mu + $J1*sin(2*$mu) + $J2*sin(4*$mu) + $J3*sin(6*$mu) + $J4*sin(8*$mu);

    $C1 = $e1sq * pow(cos($fp), 2);
    $T1 = pow(tan($fp), 2);
    $R1 = $a*(1-$e*$e)/pow(1 - $e*$e*pow(sin($fp),2), 1.5);
    $N1 = $a / sqrt(1 - $e*$e*pow(sin($fp),2));
    $D = $x / $N1;

    $Q1 = $N1 * tan($fp) / $R1;
    $Q2 = (pow($D,2)/2);
    $Q3 = (5 + 3*$T1 + 10*$C1 - 4*pow($C1,2) - 9*$e1sq) * pow($D,4)/24;
    $Q4 = (61 + 90*$T1 + 298*$C1 + 45*pow($T1,2) - 252*$e1sq - 3*pow($C1,2)) * pow($D,6)/720;
    $lat = $fp - $Q1*($Q2 - $Q3 + $Q4);

    $Q5 = $D;
    $Q6 = (1 + 2*$T1 + $C1) * pow($D,3)/6;
    $Q7 = (5 - 2*$C1 + 28*$T1 - 3*pow($C1,2) + 8*$e1sq + 24*pow($T1,2)) * pow($D,5)/120;
    $lon = deg2rad($zone_cm) + ($Q5 - $Q6 + $Q7) / cos($fp);

    return [rad2deg($lat), rad2deg($lon)];
}

// دریافت id و مرحله
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$step = isset($_GET['step']) ? intval($_GET['step']) : 1;

if ($id == 0 || $step < 1 || $step > 10) {
    die("پارامترها نادرست هستند.");
}

// واکشی اطلاعات از دیتابیس
$stmt = $conn->prepare("SELECT first_name, last_name, x, y, date$step FROM karshenasan WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$stmt->bind_result($first_name, $last_name, $x, $y, $date);
$stmt->fetch();
$stmt->close();

if (!$date || !$x || !$y) {
    die("اطلاعات یافت نشد.");
}

// تبدیل تاریخ شمسی به میلادی و سپس به ISO 8601
$parts = preg_split('/[-\/]/', $date); // پشتیبانی از هر دو جداکننده - و /
if (count($parts) === 3) {
    list($jy, $jm, $jd) = $parts;
    $g = jalali_to_gregorian((int)$jy, (int)$jm, (int)$jd);
    $miladi = sprintf('%04d-%02d-%02d', $g[0], $g[1], $g[2]);
    $timestamp = date('c', strtotime($miladi)); // فرمت ISO 8601
} else {
    $timestamp = date('c');
}

// تبدیل مختصات
list($lat, $lon) = utmToLatLon($x, $y, 39);

// ساخت فایل KML
$kml = <<<KML
<?xml version="1.0" encoding="UTF-8"?>
<kml xmlns="http://www.opengis.net/kml/2.2">
  <Placemark>
    <name>{$first_name} {$last_name} - مرحله {$step}</name>
    <TimeStamp>
      <when>{$timestamp}</when>
    </TimeStamp>
    <Point>
      <coordinates>{$lon},{$lat},0</coordinates>
    </Point>
  </Placemark>
</kml>
KML;

// ارسال فایل برای دانلود
header('Content-Type: application/vnd.google-earth.kml+xml');
header('Content-Disposition: attachment; filename="location_step' . $step . '.kml"');
echo $kml;
exit;
?>
