<?php
session_start();

// بررسی اینکه آیا کاربر وارد شده و نقش وی admin است
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: admin_login.html");
    exit;
}

include('db_connection.php');

// دریافت تعداد پرونده‌ها بر اساس وضعیت
$totalFiles = $currentFiles = $completedFiles = $suspendedFiles = 0;

$sql = "SELECT COUNT(*) AS count FROM files";
$result = $conn->query($sql);
if ($row = $result->fetch_assoc()) {
    $totalFiles = $row['count'];
}

$sql = "SELECT COUNT(*) AS count FROM files WHERE status = 'جاری'";
$result = $conn->query($sql);
if ($row = $result->fetch_assoc()) {
    $currentFiles = $row['count'];
}

$sql = "SELECT COUNT(*) AS count FROM files WHERE status = 'خاتمه یافته'";
$result = $conn->query($sql);
if ($row = $result->fetch_assoc()) {
    $completedFiles = $row['count'];
}

$sql = "SELECT COUNT(*) AS count FROM files WHERE status = 'معلق'";
$result = $conn->query($sql);
if ($row = $result->fetch_assoc()) {
    $suspendedFiles = $row['count'];
}

// دریافت تعداد پرونده‌های جاری که به هر کاربر اختصاص داده شده است
$userNames = [];
$currentFileCountsByUser = [];

$sql = "SELECT u.first_name, u.last_name, COUNT(f.file_id) AS count 
        FROM files f 
        JOIN users u ON f.assigned_to = u.user_id 
        WHERE f.status = 'جاری' 
        GROUP BY u.user_id";
$result = $conn->query($sql);
while ($row = $result->fetch_assoc()) {
    $userNames[] = $row['first_name'] . ' ' . $row['last_name'];
    $currentFileCountsByUser[] = $row['count'];
}

// دریافت تعداد پرونده‌های معلق به تفکیک دبیرخانه
$secretaryNames = [];
$suspendedFileCountsBySecretary = [];

$sql = "SELECT sec_name, COUNT(*) AS count 
        FROM files 
        WHERE status = 'معلق' 
        GROUP BY sec_name";
$result = $conn->query($sql);
while ($row = $result->fetch_assoc()) {
    $secretaryNames[] = $row['sec_name'];
    $suspendedFileCountsBySecretary[] = $row['count'];
}

// محاسبه میانگین، کمترین و بیشترین زمان سپری‌شده برای پرونده‌های خاتمه‌یافته
$minDuration = $maxDuration = $avgDuration = 0;
$durations = [];

$sql = "SELECT TIMESTAMPDIFF(DAY, start_date, end_date) AS duration 
        FROM files 
        WHERE status = 'خاتمه یافته'";
$result = $conn->query($sql);
while ($row = $result->fetch_assoc()) {
    $durations[] = $row['duration'];
}

if (count($durations) > 0) {
    $minDuration = min($durations);
    $maxDuration = max($durations);
    $avgDuration = array_sum($durations) / count($durations);
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>گزارش آماری پرونده‌ها</title>
    <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Vazir:wght@400;500&display=swap">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            font-family: 'Vazir', sans-serif;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .content {
            flex: 1;
        }
        .card {
            margin-bottom: 20px;
        }
        .chart-container {
            position: relative;
            height: 400px; /* تنظیم ارتفاع نمودار */
        }
        .charts-row {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }
        .chart-container {
            flex: 1;
            margin-right: 10px;
        }
        .chart-container:last-child {
            margin-right: 0;
        }
        .divider {
            width: 2px;
            background-color: #000;
            margin: 0 10px;
        }
        .chart-center {
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .table-row {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }
        .table-container {
            flex: 1;
            margin-right: 10px;
        }
        .table-container:last-child {
            margin-right: 0;
        }
        .table-container table {
            height: 300px; /* تنظیم ارتفاع جدول */
            overflow-y: auto;
        }
        .ml-auto {
            margin-left: auto;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#">پنل مدیریتی سامانه رصد</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav mr-auto">
                <li class="nav-item">
                    <a class="nav-link" href="admin_dashboard.php">بازگشت</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="logout.php">خروج</a>
                </li>
            </ul>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="content">
            <h1>گزارش آماری پرونده‌ها</h1>

            <div class="card">
                <div class="card-header">
                    تعداد پرونده‌ها در یک نگاه
                </div>
                <div class="card-body">
                    <p>تعداد کل پرونده‌ها: <strong><?php echo $totalFiles; ?></strong></p>
                    <p>تعداد پرونده‌های جاری: <strong><?php echo $currentFiles; ?></strong></p>
                    <p>تعداد پرونده‌های خاتمه یافته: <strong><?php echo $completedFiles; ?></strong></p>
                    <p>تعداد پرونده‌های معلق: <strong><?php echo $suspendedFiles; ?></strong></p>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    نمودار وضعیت پرونده‌ها
                </div>
                <div class="card-body">
                    <div class="charts-row">
                        <div class="chart-container">
                            <h3>نمودار ستونی تعداد پرونده‌های ثبت شده در رصد بر اساس وضعیت</h3>
                            <canvas id="statusChart"></canvas>
                        </div>
                        <div class="divider"></div>
                        <div class="chart-container chart-center">
                            <h3>نمودار دایره‌ای پرونده‌ها بر اساس وضعیت</h3>
                            <canvas id="statusPieChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    تعداد پرونده‌های جاری به تفکیک کاربر
                </div>
                <div class="card-body">
                    <div style="text-align: center;" class="chart-container">
                        <canvas id="currentFilesByUserChart"></canvas>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    تعداد پرونده‌های معلق به تفکیک دبیرخانه
                </div>
                <div class="card-body">
                    <div class="charts-row">
                        <div class="chart-container">
                            <canvas id="suspendedFilesBySecretaryChart"></canvas>
                        </div>
                        <div class="divider"></div>
                        <div class="table-container">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>دبیرخانه</th>
                                        <th>تعداد پرونده‌های معلق</th>
                                    </```html
                                </thead>
                                <tbody>
                                    <?php
                                    for ($i = 0; $i < count($secretaryNames); $i++) {
                                        echo "<tr><td>{$secretaryNames[$i]}</td><td>{$suspendedFileCountsBySecretary[$i]}</td></tr>";
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    میانگین زمان سپری‌شده برای پرونده‌های خاتمه‌یافته
                </div>
                <div class="card-body">
                    <p>کمترین زمان سپری‌شده: <strong><?php echo $minDuration; ?> روز</strong></p>
                    <p>بیشترین زمان سپری‌شده: <strong><?php echo $maxDuration; ?> روز</strong></p>
                    <p>میانگین زمان سپری‌شده: <strong><?php echo number_format($avgDuration, 2); ?> روز</strong></p>
                </div>
            </div>
        </div>
    </div>

    <script src="bootstrap/js/jquery.min.js"></script>
    <script src="bootstrap/js/bootstrap.bundle.min.js"></script>
    <script>
        var ctx = document.getElementById('statusChart').getContext('2d');
        var statusChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: ['کل پرونده‌ها', 'جاری', 'خاتمه یافته', 'معلق'],
                datasets: [{
                    label: 'تعداد پرونده‌ها',
                    data: [<?php echo $totalFiles; ?>, <?php echo $currentFiles; ?>, <?php echo $completedFiles; ?>, <?php echo $suspendedFiles; ?>],
                    backgroundColor: [
                        'rgba(75, 192, 192, 0.2)',
                        'rgba(54, 162, 235, 0.2)',
                        'rgba(255, 159, 64, 0.2)',
                        'rgba(255, 99, 132, 0.2)'
                    ],
                    borderColor: [
                        'rgba(75, 192, 192, 1)',
                        'rgba(54, 162, 235, 1)',
                        'rgba(255, 159, 64, 1)',
                        'rgba(255, 99, 132, 1)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });

        var statusPieCtx = document.getElementById('statusPieChart').getContext('2d');
        var statusPieChart = new Chart(statusPieCtx, {
            type: 'pie',
            data: {
                labels: ['جاری', 'خاتمه یافته', 'معلق'],
                datasets: [{
                    label: 'درصد پرونده‌ها بر اساس وضعیت',
                    data: [<?php echo $currentFiles; ?>, <?php echo $completedFiles; ?>, <?php echo $suspendedFiles; ?>],
                    backgroundColor: [
                        'rgba(54, 162, 235, 0.2)',
                        'rgba(255, 159, 64, 0.2)',
                        'rgba(255, 99, 132, 0.2)'
                    ],
                    borderColor: [
                        'rgba(54, 162, 235, 1)',
                        'rgba(255, 159, 64, 1)',
                        'rgba(255, 99, 132, 1)'
                    ],
                    borderWidth: 1
                }]
            }
        });

        var currentFilesByUserCtx = document.getElementById('currentFilesByUserChart').getContext('2d');
        var currentFilesByUserChart = new Chart(currentFilesByUserCtx, {
            type: 'bar',
            data: {
                labels: <?php echo json_encode($userNames); ?>,
                datasets: [{
                    label: 'تعداد پرونده‌های جاری بر اساس کاربر',
                    data: <?php echo json_encode($currentFileCountsByUser); ?>,
                    backgroundColor: 'rgba(75, 192, 192, 0.2)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });

        var suspendedFilesBySecretaryCtx = document.getElementById('suspendedFilesBySecretaryChart').getContext('2d');
        var suspendedFilesBySecretaryChart = new Chart(suspendedFilesBySecretaryCtx, {
            type: 'bar',
            data: {
                labels: <?php echo json_encode($secretaryNames); ?>,
                datasets: [{
                    label: 'تعداد پرونده‌های معلق بر اساس دبیرخانه',
                    data: <?php echo json_encode($suspendedFileCountsBySecretary); ?>,
                    backgroundColor: 'rgba(153, 102, 255, 0.2)',
                    borderColor: 'rgba(153, 102, 255, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    </script>
</body>
</html>
