<?php
// شامل فایل اتصال به دیتابیس
include 'db_connection.php';

// شامل کتابخانه PhpSpreadsheet
require 'lib/PhpSpreadsheet/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// دریافت اطلاعات از جدول files
$sql = "SELECT * FROM files";
$result = $conn->query($sql);

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$sheet->setCellValue('A1', 'ردیف');
$sheet->setCellValue('B1', 'نام اپراتور');
$sheet->setCellValue('C1', 'نام خانوادگی اپراتور');
$sheet->setCellValue('D1', 'کد ملی');
$sheet->setCellValue('E1', 'شماره تلفن');
$sheet->setCellValue('F1', 'کلاس فایل');
$sheet->setCellValue('G1', 'نوع درخواست');
$sheet->setCellValue('H1', 'شناسه مرحله');
$sheet->setCellValue('I1', 'نام مرحله');
$sheet->setCellValue('J1', 'واگذار شده به');
$sheet->setCellValue('K1', 'زمان شروع مرحله');
$sheet->setCellValue('L1', 'وضعیت');

if ($result->num_rows > 0) {
    $row_num = 2;
    while($row = $result->fetch_assoc()) {
        $sheet->setCellValue('A' . $row_num, $row_num - 1);
        $sheet->setCellValue('B' . $row_num, $row["operator_first_name"]);
        $sheet->setCellValue('C' . $row_num, $row["operator_last_name"]);
        $sheet->setCellValue('D' . $row_num, $row["national_code"]);
        $sheet->setCellValue('E' . $row_num, $row["phone_number"]);
        $sheet->setCellValue('F' . $row_num, $row["file_class"]);
        $sheet->setCellValue('G' . $row_num, $row["request_type"]);
        $sheet->setCellValue('H' . $row_num, $row["stage_id"]);
        $sheet->setCellValue('I' . $row_num, $row["stage_name"]);
        $sheet->setCellValue('J' . $row_num, $row["assigned_to"]);
        $sheet->setCellValue('K' . $row_num, $row["stage_start_time"]);
        $sheet->setCellValue('L' . $row_num, $row["status"]);
        $row_num++;
    }
}

$writer = new Xlsx($spreadsheet);
$filename = 'files_export.xlsx';

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="' . $filename . '"');
header('Cache-Control: max-age=0');
$writer->save('php://output');
?>
