<?php
session_start();
require_once "db_connection.php";

// چک کردن ورود کاربر و انقضای نشست
if (!isset($_SESSION['username'])) {
    header("Location: login.html");
    exit;
}

// اتصال به دیتابیس و بازیابی اطلاعات کاربر
$servername = "localhost";
$username = "anreoalb_archive";
$password = "Shahrooz@2681";
$dbname = "anreoalb_archive";

// اتصال به دیتابیس
$conn = new mysqli($servername, $username, $password, $dbname);

// بررسی اتصال
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// استفاده از نام کاربری از جلسه برای انتخاب اطلاعات کاربر
$username = $_SESSION['username'];

// کوئری برای انتخاب نام و نام خانوادگی کاربر
$sql = "SELECT user_id, first_name, last_name FROM users WHERE username=?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // اگر ردیفی یافت شد، اطلاعات را بازیابی کنید و به کاربر خوش آمد بگویید
    $row = $result->fetch_assoc();
    $_SESSION['user_id'] = $row['user_id']; // ذخیره کردن user_id در نشست
    $first_name = $row["first_name"];
    $last_name = $row["last_name"];
} else {
    echo "0 results";
}

// کوئری برای شمارش تعداد پرونده‌های ارجاع شده به کاربر
$user_id = $_SESSION['user_id'];
$count_query = "SELECT COUNT(*) as total FROM files WHERE assigned_to=?";
$count_stmt = $conn->prepare($count_query);
$count_stmt->bind_param("i", $user_id);
$count_stmt->execute();
$count_result = $count_stmt->get_result();
$file_count = 0;

if ($count_result->num_rows > 0) {
    $count_row = $count_result->fetch_assoc();
    $file_count = $count_row['total'];
}

$conn->close();
?>

<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>داشبورد</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Mirza:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Mirza', sans-serif;
            margin: 0;
            padding: 0;
        }
        .circle {
            background-color: red;
            border-radius: 50%;
            color: white;
            padding: 5px 10px;
            text-align: center;
            display: inline-block;
            min-width: 24px;
        }
        .sidebar {
            height: 100%;
            width: 250px;
            position: fixed;
            z-index: 1;
            top: 0;
            right: 0;
            background-color: #343a40;
            padding-top: 20px;
            overflow-x: hidden;
        }
        .sidebar img {
            display: block;
            margin: 0 auto 20px auto;
            width: 200px;
            height: 200px;
        }
        .sidebar a {
            padding: 15px;
            text-decoration: none;
            font-size: 18px;
            color: white;
            display: block;
            text-align: center;
        }
        .sidebar a:hover {
            background-color: #575d63;
        }
        .sidebar .submenu {
            display: none;
            background-color: #495057;
        }
        .sidebar .submenu a {
            padding: 10px 15px;
            font-size: 16px;
            text-align: right;
        }
        .sidebar .submenu a:hover {
            background-color: #6c757d;
        }
        .sidebar .show-submenu:hover .submenu {
            display: block;
        }
        .sidebar hr {
            border-top: 1px solid #575d63;
            margin: 10px 0;
        }
        .main {
            margin-right: 260px;
            padding: 20px;
        }
        .header {
            position: fixed;
            top: 0;
            right: 250px;
            left: 0;
            height: 60px;
            background-color: #343a40;
            color: white;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 20px;
            z-index: 2;
        }
        .header .header-title {
            flex-grow: 1;
            display: flex;
            justify-content: center;
        }
        .header .user-info {
            display: flex;
            align-items: center;
            background-color: #495057;
            padding: 5px 10px;
            border-radius: 5px;
        }
        .header .user-info span {
            margin-left: 10px;
            cursor: pointer;
        }
        .header .user-info img {
            border-radius: 50%;
            width: 40px;
            height: 40px;
            cursor: pointer;
        }
        .logout-btn {
            border: none;
            background: none;
            color: white;
            font-size: 16px;
            cursor: pointer;
            margin-left: 10px;
        }
        .content {
            margin-top: 80px; /* فاصله برای قرار دادن محتوا زیر هدر */
            background: url('logo.png') no-repeat center center;
            background-size: contain;
            opacity: 0.1;
            height: calc(100vh - 80px); /* ارتفاع محتوا بدون در نظر گرفتن ارتفاع هدر */
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <img src="logo-w.png" alt="Logo">
        <a href="admin_current.php"><i class="fas fa-folder-open"></i> مشاهده پرونده‌های جاری</a>
        <hr>
        <a href="referrals.php"><i class="fas fa-share-alt"></i> گزارش ارجاعات کاربران</a>
        <hr>
        <a href="all_files.php"><i class="fas fa-folder"></i> مشاهده همه پرونده‌ها</a>
        <hr>
        <a href="sus_list.php"><i class="fas fa-pause-circle"></i> پرونده‌های معلق</a>
        <hr>
        <a href="file_report.php"><i class="fas fa-file"></i> گزارش پرونده‌های ثبت شده</a>
        <hr>
        <div class="show-submenu">
            <a href="letter.php"><i class="fas fa-envelope"></i> ارجاع نامه</a>
            <div class="submenu">
                <a href="important_letters_responses.php"><i class="fas fa-star"></i> پاسخ نامه‌های مهم</a>
                <a href="show_letters.php"><i class="fas fa-file-alt"></i> مشاهده همه نامه‌ها</a>
            </div>
        </div>
        <hr>
        <a href="inbox.php"><i class="fas fa-inbox"></i> صندوق ورودی <span class="circle"><?php echo $file_count; ?></span></a>
        <hr>
        <a href="editor.php"><i class="fas fa-file"></i> خروجی و ویرایش</a>
        <hr>
        <a href="enter_reference_code.php"><i class="fas fa-key"></i> دریافت پرونده با کد</a>
        <hr>

        <!-- منوی جدید به همراه زیر منوی آن -->
        <div class="show-submenu">
            <a href="k_reg.html"><i class="fas fa-map-marked-alt"></i> ثبت درخواست نظارت اراضی</a>
            <div class="submenu">
                <a href="result.php"><i class="fas fa-eye"></i> مشاهده نظارت‌های اراضی</a> <!-- زیر منوی جدید اضافه شد -->
            </div>
        </div>
        <hr>
    </div>

    <div class="header">
        <div class="header-title">
            <h2>سامانه رصد سازمان نظام مهندسی کشاورزی و منابع طبیعی استان البرز</h2>
        </div>
        <div class="user-info">
            <img src="avatar.png" alt="Avatar">
            <span><?php echo htmlspecialchars($first_name) . " " . htmlspecialchars($last_name); ?></span>
            <button class="logout-btn" onclick="document.getElementById('logout-form').submit();"><i class="fas fa-sign-out-alt"></i> خروج</button>
        </div>
    </div>

    <div class="main content">
        <!-- محتوای اصلی اینجا قرار می‌گیرد -->
    </div>

    <form id="logout-form" action="logout.php" method="post" style="display: none;"></form>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
