<?php
session_start();
require_once "db_connection.php";

// چک کردن ورود کاربر
if (!isset($_SESSION['username'])) {
    header("Location: login.html");
    exit;
}

// اتصال به دیتابیس
$conn = new mysqli("localhost", "anreoalb_archive", "Shahrooz@2681", "anreoalb_archive");

// بررسی اتصال
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// کوئری برای بازیابی اطلاعات پرونده‌های جاری به همراه زمان مجاز و نام مرحله بر اساس نوع درخواست
$query = "
SELECT f.file_id, f.file_class, f.operator_first_name, f.operator_last_name, f.national_code, f.status, f.stage_name, f.stage_start_time, f.request_type, u.first_name AS user_first_name, u.last_name AS user_last_name, 
CASE 
    WHEN f.request_type = 'صدور تاسیس گلخانه' THEN s.allowed_time
    WHEN f.request_type = 'تمدید بهره برداری دام/طیور/شیلات' THEN tbd.allowed_time
    WHEN f.request_type = 'تمدید تاسیس گلخانه' THEN tt.allowed_time
    WHEN f.request_type = 'تغییر نام گلخانه' THEN tn.allowed_time
    WHEN f.request_type = 'بهسازی و نوسازی گلخانه' THEN bn.allowed_time
    WHEN f.request_type = 'تغییر کشت' THEN tk.allowed_time
    WHEN f.request_type = 'صدور بهره برداری گلخانه' THEN bs.allowed_time
    WHEN f.request_type = 'اصلاح بهره برداری گلخانه' THEN ebs.allowed_time
    WHEN f.request_type = 'تمدید توسعه گلخانه' THEN tt2.allowed_time
    WHEN f.request_type = 'توسعه گلخانه' THEN st.allowed_time
    WHEN f.request_type = 'تمدید بهره برداری گلخانه' THEN b2.allowed_time
    WHEN f.request_type = 'اصلاح تاسیس گلخانه' THEN et.allowed_time
    WHEN f.request_type = 'تمدید دامداری غیر صنعتی' THEN tdg.allowed_time
    WHEN f.request_type = 'صدور بهره برداری دام/طیور/شیلات' THEN sbd.allowed_time
    WHEN f.request_type = 'صدور دامداری غیر صنعتی' THEN sdg.allowed_time
    WHEN f.request_type = 'تمدید توسعه قارچ' THEN ttgh.allowed_time
    WHEN f.request_type = 'موافقت اصولی دام/طیور/شیلات' THEN mo.allowed_time
    WHEN f.request_type = 'تمدید تاسیس داروخانه' THEN ttc.allowed_time
    WHEN f.request_type = 'تغییر نام بهره برداری دام' THEN tnt.allowed_time
    WHEN f.request_type = 'صدور تاسیس داروخانه گیاهپزشکی' THEN stg.allowed_time
    WHEN f.request_type = 'توسعه و افزایش ظرفیت دام/طیور/شیلات' THEN taz.allowed_time
    WHEN f.request_type = 'اصلاح دامداری غیر صنعتی' THEN edg.allowed_time
    WHEN f.request_type = 'صدور تاسیس دام/طیور/شیلات' THEN std.allowed_time
    WHEN f.request_type = 'تمدید بهره برداری قارچ' THEN tbgh.allowed_time
    WHEN f.request_type = 'تمدید تاسیس دام/طیور/شیلات' THEN ttd.allowed_time
    WHEN f.request_type = 'صدور تاسیس قارچ' THEN stgh.allowed_time
    ELSE NULL
END AS allowed_time
FROM files f
LEFT JOIN stages s ON f.stage_id = s.stage_id AND f.request_type = 'صدور تاسیس گلخانه'
LEFT JOIN tbdstage tbd ON f.stage_id = tbd.stage_id AND f.request_type = 'تمدید بهره برداری دام/طیور/شیلات'
LEFT JOIN ttstage tt ON f.stage_id = tt.stage_id AND f.request_type = 'تمدید تاسیس گلخانه'
LEFT JOIN tnstage tn ON f.stage_id = tn.stage_id AND f.request_type = 'تغییر نام گلخانه'
LEFT JOIN bnstage bn ON f.stage_id = bn.stage_id AND f.request_type = 'بهسازی و نوسازی گلخانه'
LEFT JOIN tkstage tk ON f.stage_id = tk.stage_id AND f.request_type = 'تغییر کشت'
LEFT JOIN bstage bs ON f.stage_id = bs.stage_id AND f.request_type = 'صدور بهره برداری گلخانه'
LEFT JOIN ebstage ebs ON f.stage_id = ebs.stage_id AND f.request_type = 'اصلاح بهره برداری گلخانه'
LEFT JOIN tt2stage tt2 ON f.stage_id = tt2.stage_id AND f.request_type = 'تمدید توسعه گلخانه'
LEFT JOIN stages st ON f.stage_id = st.stage_id AND f.request_type = 'توسعه گلخانه'
LEFT JOIN b2stage b2 ON f.stage_id = b2.stage_id AND f.request_type = 'تمدید بهره برداری گلخانه'
LEFT JOIN etstage et ON f.stage_id = et.stage_id AND f.request_type = 'اصلاح تاسیس گلخانه'
LEFT JOIN tdgstage tdg ON f.stage_id = tdg.stage_id AND f.request_type IN ('تمدید دامداری غیر صنعتی', 'تمدید دامداری غیر صنعتی')
LEFT JOIN sbdstage sbd ON f.stage_id = sbd.stage_id AND f.request_type = 'صدور بهره برداری دام/طیور/شیلات'
LEFT JOIN sdgstage sdg ON f.stage_id = sdg.stage_id AND f.request_type = 'صدور دامداری غیر صنعتی'
LEFT JOIN ttghstage ttgh ON f.stage_id = ttgh.stage_id AND f.request_type = 'تمدید توسعه قارچ'
LEFT JOIN mostage mo ON f.stage_id = mo.stage_id AND f.request_type = 'موافقت اصولی دام/طیور/شیلات'
LEFT JOIN ttcstage ttc ON f.stage_id = ttc.stage_id AND f.request_type = 'تمدید تاسیس داروخانه'
LEFT JOIN tntstage tnt ON f.stage_id = tnt.stage_id AND f.request_type = 'تغییر نام بهره برداری دام'
LEFT JOIN stgstage stg ON f.stage_id = stg.stage_id AND f.request_type = 'صدور تاسیس داروخانه گیاهپزشکی'
LEFT JOIN tazstage taz ON f.stage_id = taz.stage_id AND f.request_type = 'توسعه و افزایش ظرفیت دام/طیور/شیلات'
LEFT JOIN edgstage edg ON f.stage_id = edg.stage_id AND f.request_type = 'اصلاح دامداری غیر صنعتی'
LEFT JOIN stdstage std ON f.stage_id = std.stage_id AND f.request_type = 'صدور تاسیس دام/طیور/شیلات'
LEFT JOIN tbghstage tbgh ON f.stage_id = tbgh.stage_id AND f.request_type = 'تمدید بهره برداری قارچ'
LEFT JOIN ttdstage ttd ON f.stage_id = ttd.stage_id AND f.request_type = 'تمدید تاسیس دام/طیور/شیلات'
LEFT JOIN stghstage stgh ON f.stage_id = stgh.stage_id AND f.request_type = 'صدور تاسیس قارچ'

LEFT JOIN users u ON f.assigned_to = u.user_id
WHERE f.status = 'جاری'";
$result = $conn->query($query);

if (!$result) {
    die("Query failed: " . $conn->error);
}
?>

<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پرونده‌های جاری</title>
    <link rel="stylesheet" href="table.css">
    <script>
    function startTimer(duration, display, row) {
        var timer = duration, days, hours, minutes, seconds;
        setInterval(function () {
            if (timer >= 0) {
                days = parseInt(timer / 86400, 10);
                hours = parseInt((timer % 86400) / 3600, 10);
                minutes = parseInt((timer % 3600) / 60, 10);
                seconds = parseInt(timer % 60, 10);

                days = days < 10 ? "0" + days : days;
                hours = hours < 10 ? "0" + hours : hours;
                minutes = minutes < 10 ? "0" + minutes : minutes;
                seconds = seconds < 10 ? "0" + seconds : seconds;

                display.textContent = days + " روز " + hours + ":" + minutes + ":" + seconds;

                if (timer < 43200) { // کمتر از 12 ساعت
                    row.style.backgroundColor = "red";
                } else if (timer < 86400) { // بین 12 تا 24 ساعت
                    row.style.backgroundColor = "orange";
                }

                if (--timer < 0) {
                    display.textContent = "زمان تمام شده";
                    row.style.backgroundColor = "red"; // تغییر رنگ پس‌زمینه ردیف به قرمز
                }
            } else {
                // زمانی که timer منفی است، زمان گذشته را محاسبه و نمایش می‌دهیم
                var overTime = -timer;
                days = parseInt(overTime / 86400, 10);
                hours = parseInt((overTime % 86400) / 3600, 10);
                minutes = parseInt((overTime % 3600) / 60, 10);
                seconds = parseInt(overTime % 60, 10);

                days = days < 10 ? "0" + days : days;
                hours = hours < 10 ? "0" + hours : hours;
                minutes = minutes < 10 ? "0" + minutes : minutes;
                seconds = seconds < 10 ? "0" + seconds : seconds;

                display.textContent = "زمان گذشته: " + days + " روز " + hours + ":" + minutes + ":" + seconds;
                row.style.backgroundColor = "red"; // تغییر رنگ پس‌زمینه ردیف به قرمز
            }
        }, 1000);
    }

    window.onload = function () {
        var timers = document.querySelectorAll('.timer');
        timers.forEach(function(timerElement) {
            var allowedTime = parseInt(timerElement.dataset.allowedTime) * 60; // تبدیل دقیقه به ثانیه
            var startTime = new Date(timerElement.dataset.startTime).getTime();
            var now = new Date().getTime();
            var elapsedTime = Math.floor((now - startTime) / 1000);
            var remainingTime = allowedTime - elapsedTime;

            var row = timerElement.closest('tr');
            var stageName = row.querySelector('.stage-name').textContent;

            if (stageName === "زمانبری پرداخت") {
                // برای مرحله "زمانبری پرداخت" رنگ پس‌زمینه آبی آسمانی و تایمر نمایش داده شود
                row.style.backgroundColor = "#87CEFA"; // آبی آسمانی
                if (remainingTime >= 0) {
                    timerElement.textContent = "زمان باقی مانده: " + formatTime(remainingTime);
                } else {
                    timerElement.textContent = "زمان گذشته: " + formatTime(-remainingTime);
                }
            } else {
                // برای سایر مراحل، تایمر شروع می‌شود
                startTimer(remainingTime, timerElement, row);
            }
        });
    };

    function formatTime(seconds) {
        var days = Math.floor(seconds / 86400);
        var hours = Math.floor((seconds % 86400) / 3600);
        var minutes = Math.floor((seconds % 3600) / 60);
        var secs = seconds % 60;

        days = days < 10 ? "0" + days : days;
        hours = hours < 10 ? "0" + hours : hours;
        minutes = minutes < 10 ? "0" + minutes : minutes;
        secs = secs < 10 ? "0" + secs : secs;

        return days + " روز " + hours + ":" + minutes + ":" + secs;
    }

            function liveSearch() {
    var input, filter, table, tr, td, i, j, txtValue, count;
    input = document.getElementById("searchInput");
    filter = input.value.toUpperCase();
    table = document.querySelector("table");
    tr = table.getElementsByTagName("tr");
    count = 0; // Initialize count for found results
    
    var stageCounts = {}; // Object to store stage counts

    for (i = 1; i < tr.length; i++) {
        tr[i].style.display = "none";
        td = tr[i].getElementsByTagName("td");
        for (j = 0; j < td.length; j++) {
            if (td[j]) {
                txtValue = td[j].textContent || td[j].innerText;
                if (txtValue.toUpperCase().indexOf(filter) > -1) {
                    tr[i].style.display = "";
                    count++; // Increment count for each matching row

                    // Get the stage name from the column "نام مرحله" (assuming it's the appropriate column index)
                    var stageText = tr[i].getElementsByTagName("td")[7].textContent || tr[i].getElementsByTagName("td")[7].innerText; // Change index 2 to the correct index
                    if (stageCounts[stageText]) {
                        stageCounts[stageText]++;
                    } else {
                        stageCounts[stageText] = 1;
                    }
                    break;
                }
            }
        }
    }

    document.getElementById("resultCount").innerText = " تعداد پرونده های یافت شده" + count;

    var stageCountList = document.getElementById("stageCount");
    stageCountList.innerHTML = ""; // Clear previous list items
    if (filter) { // Only update the stage counts if there is a filter applied
        for (var stage in stageCounts) {
            var li = document.createElement("li");
            li.innerText = stage + ": " + stageCounts[stage] + " فقره";
            stageCountList.appendChild(li);
        }
    }
}

function presetSearch(query) {
    document.getElementById("searchInput").value = query;
    liveSearch();
}

    function showTemporaryNotes(fileId) {
        var xhr = new XMLHttpRequest();
        xhr.open("POST", "get_temporary_notes.php", true);
        xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4 && xhr.status == 200) {
                var response = JSON.parse(xhr.responseText);
                var notes = response.temporary_note;
                document.getElementById("temporaryNotesContent").innerText = notes;
                document.getElementById("temporaryNotesModal").style.display = "block";
            }
        };
        xhr.send("file_id=" + fileId);
    }

    function closeModal() {
        document.getElementById("temporaryNotesModal").style.display = "none";
    }
</script>




</head>
<body>
<div class="container">
    <header>
        <h2>پرونده‌های جاری - سامانه رصد سازمان نظام مهندسی کشاورزی و منابع طبیعی استان البرز</h2>
    </header>
    <main>
        <input type="text" id="searchInput" onkeyup="liveSearch()" placeholder="جستجو در پرونده‌ها...">
        <button onclick="presetSearch('سعادتخانی')">سعادت خانی</button>
        <button onclick="presetSearch('سمانه جعفری')">جعفری</button>
        <button onclick="presetSearch('ساناز فولادوند')">فولادوند</button>
        <button onclick="presetSearch('علیشیری')">علیشیری</button>
        <button onclick="presetSearch('لیلا محمدی')">محمدی</button>
        <button onclick="presetSearch('لیلا ملکی')">ملکی</button>

        <p id="resultCount"></p>
        <ul id="stageCount"></ul>
        <?php if ($result->num_rows > 0) { ?>
            <table>
                <thead>
                <tr>
                    <th>شماره ردیف</th>
                    <th>کلاس پرونده</th>
                    <th>نام بهره‌بردار</th>
                    <th>نام خانوادگی بهره‌بردار</th>
                    <th>کد ملی</th>
                    <th>وضعیت</th>
                    <th>نوع درخواست</th>
                    <th class="stage-name">نام مرحله</th>
                    <th>زمان باقی‌مانده</th>
                    <th>نام و نام خانوادگی کاربر مسئول</th>
                    <th>نمایش یادداشت‌های موقت</th>
                    <th>نمایش ورک فلو</th>
                </tr>
                </thead>
                <tbody>
                <?php 
                $rowNumber = 1;
                while ($row = $result->fetch_assoc()) { ?>
                    <tr>
                        <td><?php echo $rowNumber++; ?></td>
                        <td><?php echo $row['file_class']; ?></td>
                        <td><?php echo $row['operator_first_name']; ?></td>
                        <td><?php echo $row['operator_last_name']; ?></td>
                        <td><?php echo $row['national_code']; ?></td>
                        <td><?php echo $row['status']; ?></td>
                        <td><?php echo $row['request_type']; ?></td>
                        <td class="stage-name"><?php echo $row['stage_name']; ?></td>
                        <td>
                            <?php if ($row['allowed_time'] !== NULL) { ?>
                                <span class="timer" data-allowed-time="<?php echo $row['allowed_time']; ?>" data-start-time="<?php echo $row['stage_start_time']; ?>"></span>
                            <?php } else { ?>
                                اطلاعات زمان مجاز در دسترس نیست
                            <?php } ?>
                        </td>
                        <td><?php echo $row['user_first_name'] . ' ' . $row['user_last_name']; ?></td>
                        <td>
                            <button onclick="showTemporaryNotes(<?php echo $row['file_id']; ?>)">نمایش یادداشت‌های موقت</button>
                        </td>
                        <td>
                            <form action="workflow_view.php" method="get" style="display:inline;">
                                <input type="hidden" name="file_id" value="<?php echo $row['file_id']; ?>">
                                <button type="submit">نمایش ورک‌فلو</button>
                            </form>
                        </td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        <?php } else { ?>
            <p>هیچ پرونده‌ای در حالت جاری وجود ندارد.</p>
        <?php } ?>
    </main>
    <footer>
        <a href="admin_dashboard.php">بازگشت به داشبورد</a>
        <form action="logout.php" method="post">
            <button type="submit">خروج</button>
        </form>
    </footer>
</div>

<div id="temporaryNotesModal" class="modal">
    <div class="modal-content">
        <span class="close" onclick="closeModal()">&times;</span>
        <h2>یادداشت‌های موقت</h2>
        <p id="temporaryNotesContent"></p>
    </div>
</div>

<style>
    .modal {
        display: none;
        position: fixed;
        z-index: 1;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgb(0,0,0);
        background-color: rgba(0,0,0,0.4);
    }

    .modal-content {
        background-color: #fefefe;
        margin: 15% auto;
        padding: 20px;
        border: 1px solid #888;
        width: 80%;
    }

    .close {
        color: #aaa;
        float: right;
        font-size: 28px;
        font-weight: bold;
    }

    .close:hover,
    .close:focus {
        color: black;
        text-decoration: none;
        cursor: pointer;
    }
</style>
</body>
</html>
