<?php
session_start();

// بررسی اینکه آیا کاربر وارد شده و نقش وی admin است
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: admin_login.html");
    exit;
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پنل مدیریتی - رصد</title>
    <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Vazir:wght@400;500&display=swap">
    <style>
        body {
            font-family: 'Vazir', sans-serif;
            display: flex;
            min-height: 100vh;
            flex-direction: column;
        }
        .wrapper {
            display: flex;
            flex: 1;
        }
        .sidebar {
            min-width: 250px;
            max-width: 250px;
            background: #343a40;
            color: #fff;
            padding: 15px;
        }
        .sidebar a {
            color: #fff;
            text-decoration: none;
        }
        .sidebar .nav-link {
            padding: 10px;
        }
        .sidebar .logo {
            text-align: center;
            margin-bottom: 15px;
        }
        .sidebar .logo img {
            width: 200px;
            height: 200px;
            object-fit: cover;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#">پنل مدیریتی سامانه رصد سازمان نظام مهندسی کشاورزی و منابع طبیعی استان البرز</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="#">خروج</a>
                </li>
            </ul>
        </div>
    </nav>

    <div class="wrapper">
        <div class="sidebar">
            <div class="logo">
                <img src="logo-w.png" alt="لوگو">
            </div>
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a class="nav-link" href="file_report.php">گزارش پرونده‌های ثبت شده</a>
                </li>
                <hr>
                <li class="nav-item">
                    <a class="nav-link" href="#">گزارشات دیگر</a>
                </li>
            </ul>
        </div>

        <div class="content p-4">
            <h1>به پنل مدیریت خوش آمدید</h1>
            <p>محتوای اینجا قرار می‌گیرد.</p>
        </div>
    </div>

    <script src="bootstrap/js/jquery.min.js"></script>
    <script src="bootstrap/js/bootstrap.bundle.min.js"></script>
</body>
</html>
