<?php
session_start();
require_once "db_connection.php";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $operator_first_name = $_POST["operator_first_name"];
    $operator_last_name = $_POST["operator_last_name"];
    $national_code = $_POST["national_code"];
    $file_class = $_POST["file_class"];
    $phone_number = $_POST["phone_number"];
    $request_type = $_POST["request_type"];

    // بررسی صحت نوع درخواست
    $valid_request_types = array(
        "صدور تاسیس گلخانه", 
        "توسعه گلخانه", 
        "تمدید بهره برداری گلخانه", 
        "تغییر نام گلخانه", 
        "بهسازی و نوسازی گلخانه", 
        "تغییر کشت", 
        "صدور بهره برداری گلخانه", 
        "اصلاح بهره برداری گلخانه", 
        "تمدید تاسیس گلخانه", 
        "تمدید توسعه گلخانه", 
        "اصلاح تاسیس گلخانه",
        "اصلاح تاسیس دام/طیور/شیلات", 
        "اصلاح بهره برداری دام/طیور/شیلات", 
        "تمدید بهره برداری دام/طیور/شیلات", 
        "تمدید تاسیس دام/طیور/شیلات", 
        "صدور بهره برداری دام/طیور/شیلات", 
        "توسعه و افزایش ظرفیت دام/طیور/شیلات", 
        "موافقت اصولی دام/طیور/شیلات", 
        "بهسازی و نوسازی دام/طیور/شیلات",
        "تغییر نام تاسیس دام/طیور/شیلات",
        "تغییر نام بهره برداری دام",
        "صدور دامداری غیر صنعتی",
        "تمدید دامداری غیر صنعتی",
        "اصلاح دامداری غیر صنعتی",
        "صدور بهره برداری انسکتاریوم",
        "تمدید بهره برداری انسکتاریوم",
        "اصلاح انسکتاریوم",
        "تغییر نام انسکتاریوم",
        "صدور تاسیس داروخانه گیاهپزشکی",
        "اصلاح تاسیس و بهره برداری کلینیک",
        "اصلاح تاسیس داروخانه",
        "تاسیس صدور کلینیک گیاهپزشکی",
        "صدور بهره برداری کلینیک گیاهپزشکی",
        "تمدید تاسیس داروخانه",
        "تمدید کلینیک گیاهپزشکی",
        "تمدید تاسیس انسکتاریوم",
        "صدور تاسیس انسکتاریوم",
        "تمدید تاسیس قارچ",         
        "تمدید توسعه قارچ",         
        "صدور تاسیس دام/طیور/شیلات", 
        "تمدید بهره برداری قارچ",
        "صدور توسعه قارچ",        // اضافه شده
        "صدور تاسیس قارچ"         // اضافه شده
    );

    if (!in_array($request_type, $valid_request_types)) {
        echo "خطا: نوع درخواست معتبر نیست.";
        exit;
    }

    // اجرای کوئری برای بازیابی نام مرحله از جدول stages
    $stage_query = "SELECT stage_name FROM stages WHERE stage_id = 1";
    $stage_result = $conn->query($stage_query);
    if ($stage_result->num_rows > 0) {
        $row = $stage_result->fetch_assoc();
        $referral_stage_name = $row["stage_name"];
    } else {
        echo "خطا: مرحله مورد نظر یافت نشد.";
        exit;
    }

    // زمان فعلی
    $current_time = date("Y-m-d H:i:s");

    // تنظیم وضعیت جاری
    $current_status = "جاری";

    // کوئری برای درج رکورد جدید در جدول فایل‌ها
    $query = "INSERT INTO files (operator_first_name, operator_last_name, national_code, file_class, phone_number, request_type, stage_id, stage_name, assigned_to, stage_start_time, status) VALUES (?, ?, ?, ?, ?, ?, 1, ?, 3, ?, ?)";

    $stmt = $conn->prepare($query);
    $stmt->bind_param("sssssssss", $operator_first_name, $operator_last_name, $national_code, $file_class, $phone_number, $request_type, $referral_stage_name, $current_time, $current_status);
    if ($stmt->execute()) {
        // انتقال به صفحه موفقیت بعد از ثبت موفق
        header("Location: success_page.php");
        exit;
    } else {
        echo "خطا: " . $conn->error;
    }

    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>ثبت پرونده جدید</title>
<link rel="stylesheet" href="add.css">
</head>
<body>
<div class="container">
  <header>
    <h2>ثبت پرونده جدید</h2>
  </header>
  <main>
    <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
      <div class="form-group">
        <label for="operator_first_name">نام:</label>
        <input type="text" id="operator_first_name" name="operator_first_name" required>
      </div>
      <div class="form-group">
        <label for="operator_last_name">نام خانوادگی:</label>
        <input type="text" id="operator_last_name" name="operator_last_name" required>
      </div>
      <div class="form-group">
        <label for="national_code">کد ملی:</label>
        <input type="text" id="national_code" name="national_code" required>
      </div>
      <div class="form-group">
        <label for="file_class">کلاسه پرونده:</label>
        <input type="text" id="file_class" name="file_class" required>
      </div>
      <div class="form-group">
        <label for="phone_number">شماره تماس:</label>
        <input type="text" id="phone_number" name="phone_number" required>
      </div>
      <div class="form-group">
        <label for="request_type">نوع درخواست:</label>
        <select id="request_type" name="request_type" required>
          <option value="صدور تاسیس گلخانه">صدور تاسیس گلخانه</option>
          <option value="توسعه گلخانه">توسعه گلخانه</option>
          <option value="تمدید بهره برداری گلخانه">تمدید بهره برداری گلخانه</option>
          <option value="تغییر نام گلخانه">تغییر نام گلخانه</option>
          <option value="بهسازی و نوسازی گلخانه">بهسازی و نوسازی گلخانه</option>
          <option value="تغییر کشت">تغییر کشت</option>
          <option value="صدور بهره برداری گلخانه">صدور بهره برداری گلخانه</option>
          <option value="اصلاح بهره برداری گلخانه">اصلاح بهره برداری گلخانه</option>
          <option value="تمدید تاسیس گلخانه">تمدید تاسیس گلخانه</option>
          <option value="تمدید توسعه گلخانه">تمدید توسعه گلخانه</option>
          <option value="اصلاح تاسیس گلخانه">اصلاح تاسیس گلخانه</option>
          <option value="اصلاح تاسیس دام/طیور/شیلات">اصلاح تاسیس دام/طیور/شیلات</option>
          <option value="اصلاح بهره برداری دام/طیور/شیلات">اصلاح بهره برداری دام/طیور/شیلات</option>
          <option value="تمدید بهره برداری دام/طیور/شیلات">تمدید بهره برداری دام/طیور/شیلات</option>
          <option value="تمدید تاسیس دام/طیور/شیلات">تمدید تاسیس دام/طیور/شیلات</option>
          <option value="صدور بهره برداری دام/طیور/شیلات">صدور بهره برداری دام/طیور/شیلات</option>
          <option value="توسعه و افزایش ظرفیت دام/طیور/شیلات">توسعه و افزایش ظرفیت دام/طیور/شیلات</option>
          <option value="موافقت اصولی دام/طیور/شیلات">موافقت اصولی دام/طیور/شیلات</option>
          <option value="بهسازی و نوسازی دام/طیور/شیلات">بهسازی و نوسازی دام/طیور/شیلات</option>
          <option value="تغییر نام تاسیس دام/طیور/شیلات">تغییر نام تاسیس دام/طیور/شیلات</option>
          <option value="تغییر نام بهره برداری دام">تغییر نام بهره برداری دام</option>
          <option value="صدور دامداری غیر صنعتی">صدور دامداری غیر صنعتی</option>
          <option value="تمدید دامداری غیر صنعتی">تمدید دامداری غیر صنعتی</option>
          <option value="اصلاح دامداری غیر صنعتی">اصلاح دامداری غیر صنعتی</option>
          <option value="صدور بهره برداری انسکتاریوم">صدور بهره برداری انسکتاریوم</option>
          <option value="تمدید بهره برداری انسکتاریوم">تمدید بهره برداری انسکتاریوم</option>
          <option value="اصلاح انسکتاریوم">اصلاح انسکتاریوم</option>
          <option value="تغییر نام انسکتاریوم">تغییر نام انسکتاریوم</option>
          <option value="صدور تاسیس داروخانه گیاهپزشکی">صدور تاسیس داروخانه گیاهپزشکی</option>
          <option value="اصلاح تاسیس و بهره برداری کلینیک">اصلاح تاسیس و بهره برداری کلینیک</option>
          <option value="اصلاح تاسیس داروخانه">اصلاح تاسیس داروخانه</option>
          <option value="تاسیس صدور کلینیک گیاهپزشکی">تاسیس صدور کلینیک گیاهپزشکی</option>
          <option value="صدور بهره برداری کلینیک گیاهپزشکی">صدور بهره برداری کلینیک گیاهپزشکی</option>
          <option value="تمدید تاسیس داروخانه">تمدید تاسیس داروخانه</option>
          <option value="تمدید کلینیک گیاهپزشکی">تمدید کلینیک گیاهپزشکی</option>
          <option value="تمدید تاسیس انسکتاریوم">تمدید تاسیس انسکتاریوم</option>
          <option value="صدور تاسیس انسکتاریوم">صدور تاسیس انسکتاریوم</option>
          <option value="تمدید تاسیس قارچ">تمدید تاسیس قارچ</option>        
          <option value="تمدید توسعه قارچ">تمدید توسعه قارچ</option>        
          <option value="صدور تاسیس دام/طیور/شیلات">صدور تاسیس دام/طیور/شیلات</option> 
          <option value="تمدید بهره برداری قارچ">تمدید بهره برداری قارچ</option>
          <option value="صدور توسعه قارچ">صدور توسعه قارچ</option>        <!-- اضافه شده -->
          <option value="صدور تاسیس قارچ">صدور تاسیس قارچ</option>         <!-- اضافه شده -->
        </select>
      </div>
      <div class="form-group">
        <button type="submit">ثبت</button>
      </div>
    </form>
  </main>
</div>
</body>
</html>
